using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class CROSS_REFERENCE_PATIENTIDDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public CROSS_REFERENCE_PATIENTIDDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public CROSS_REFERENCE_PATIENTID GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string PatientICN)
		{
			CROSS_REFERENCE_PATIENTID objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_CROSS_REFERENCE_PATIENTID_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, PatientICN).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<CROSS_REFERENCE_PATIENTID> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<CROSS_REFERENCE_PATIENTID> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_CROSS_REFERENCE_PATIENTID_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public string Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, CROSS_REFERENCE_PATIENTID objSave)
		{
			string objReturn = objSave.PatientICN;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_CROSS_REFERENCE_PATIENTID_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CreatedBy, objSave.OLD_CODE, objSave.OLD_DESCRIPTION_TEXT, objSave.OLD_NAME, objSave.Old_Patient_ID, objSave.Old_ReFerral_Id, objSave.Old_STD_Referralsts_ID, objSave.Old_STD_Registry_ID, ref objReturn, DateTime.Now, objSave.UpdatedBy, objSave.VIRP_Patient_ID, objSave.VIRP_ReFerral_Id, objSave.VIRP_STD_Referralsts_ID, objSave.VIRP_STD_Registry_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string PatientICN)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_CROSS_REFERENCE_PATIENTID_delete(CURRENT_USER, CURRENT_REGISTRY_ID, PatientICN);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
